        DEBUGX EQU 0FFFFh
;       TIME DELAY VALUES:
;PUTSEC  (AND ATTOPC) TIME DELAYS:

; ********** WARNING: DON'T USE T1, ETC. AS *************
; A LOCAL CODE LABEL!! IT WILL SUPERSEDE THE TIMING VALUE
; BELOW.

; 3.17 - Changed timing values based on Terry Chamberlain's
; letter and the fact that my timing routine is twice as fast
; as I had thought ...

	DB 'TIME DELAY VALUES: T1-T8, 2 BYTES PER ENTRY: '
T1	DW 0300h; BEFORE FIRST ACK ; 3.17: was 100
T2	DW 4000; BEFORE SECOND ACK TYP 850 uS TO 16mS; 3.19 4K, WAS: 2K
T3	DW 0300h; BEFORE 'COMPLETE', TYP 250 uS TO 255 S 3.17 - was 300

;GETSEC TIME DELAYS (ALSO FOR STATUS)

T4	DW 0300h; BEFORE 'COMPLETE', TYP 250uS TO 255 S; 3.17 - was 300
T5	DW 0300h; BETWEEN 'COMPLETE' AND DATA FRAME; 3.17 - was 500
T6      DW 0; Time delay between bytes of data frame to Atari
T7      DW 8; Time delay between accesses to 8250 chip  - 4.10 from 0 to 8
T8      DW 0; Delay between records send to real printer (jiffies)
T9      DW 6; Divisor to set baud rate on 8250
;             6 = 19.2K; 3 = 38.4K; 4 = 28.8K

; Values for HOWFAST routine:

HFAST   DW 0 ; high word of number of counts in 55 ms
LFAST   DW 0 ; low word "                           "
TWO_US  DW 0 ; # of counts in an equivalent loop to give 2 us. If zero,
             ; a rough delay will be substituted.

; Time values for 1050-2-PC: (rev 3.20)

DT1    DW 1800 ; 750 uS delay after cmnd line dropped
DT2:   DW 3000 ; delay before sector data sent (T3 on page 150
	DB 'FOLLOWING: ATARI HIGH SPEED INDEX (BYTE) AND PC'
	DB ' DIVISOR (WORD):'
INDEX   DB 16
PCDIV   DW 3

; Three values below for testing/breaking in new TIMER_0, 4.20:

INITIAL DW 0
FINAL   DW 0
DIFFERENCE DW 0

; Values for console speaker beeps

BEEPCNT DW 2000 ; counter value determines tone
BEEPTIME DW 1 ; length of beep in 1/18 ths of a second
SOUND DB 0FFh ; value of 0 means don't make sound;  4.16
SOUNDON: DB 'Sound ON$'
SOUNDOFF: DB 'Sound OFF$'

;	 3.20 - Variables for the 1050-2-PC routines

D_SIZE DW 128 ; number of bytes per sector
D_TRACKS  DB 26 ; define sectors/track for use in multiplication
	  DB 0 ; so D_TRACKS can also be read as a WORD
D_ID DB 031h ; 031h is disk drive #1, etc
D_RESPONS: DB 'READ STATUS: '
E_1050: DB '___$',0,0 ; error statuses
DSA_E15: DB 13,10
        DB 'After a bad read operation a three character field gives'
        DB 13,10
        DB 'the actual outcome of the expected ACK (A), COMPLETE (C) and'
        DB 13,10
        DB 'CHECKSUM bytes:',13,10,13,10
        DB 'T means timed out waiting for character.  Otherwise, actual'
        DB 13,10
        DB 'character received is shown for A & C fields (underscore means'
        DB 13,10
        DB 'not received). In CHECKSUM field, G means good checksum, B'
        DB 13,10,
        DB 'means bad.  One retry is attempted after a READ ERROR'
        DB 13,10
        DB 'ACG is a good status.  The drive may return <E>rror, <N>ak, '
        DB 13,10
        DB 'or simply not respond to a request resulting in a problem.'
        DB 13,10
        DB 'Status bytes of 00 00 00 00 means no status was obtained.'
        DB 13,10,13,10,'$'
E_STOP: DB 'Stop on error? (Y/N)',13,10,'$'
E_STOPY DB ' ' ; 'Y' means stop on error
E_CONT: DB 13,10,'Press <C> to continue, any other key to cancel current series'
        DB 13,10,'$'
D_STATS:   DB 0,0,0,0 ; STATUS, in reverse order, 3,2,1,0
D_HANDL DW 0
D_TOTAL DW 0 ; total number of sectors
D_1ST DW 0 ; 1st sector to get
D_LAST DW 0 ; last sector to get
AD_TYPE DB '1' ; choice of SIO2PC or image only file
A_LOSEC: DB '    ',0
A_HISEC: DB '    ',0
D_SAGH: DB 13,10,'Enter first (lower) sector number: ','$'
D_SAGL: DB 13,10,'Enter second (higher) sector number: ','$'
D_RETRY  DB 1 ; number of retries in reading sector
D_RETRY2 DB 3 ; normal is 3 retries
SCAN_MOR: DB '[SpaceBar] to scan more, any other key to exit ...$'
USR_QUIT: DB 13,10,'Command cancelled by user ... ',13,10,'$'
SA_RETRY: DB 'ERROR! Retrying ... ',13,10,'$'
D_EXCEED: DB 'EXCEEDED RETRY COUNT.',13,10
        DB 'Press 1 to terminate operation',13,10
        DB 'Press 2 to write dummy data and continue',13,10
        DB 'Press 3 to skip remainder of this track',13,10
        DB 'Press 4 to skip remainder of disk',13,10,'$'
D_CHOSE  DB ' '; user's choice goes here
ABT_FMT: DB 'Format Command Cancelled',13,10,'$'
FMT_CPT: DB 'Format Command Completed.',13,10,'$'
HAS_BADS: DB 'Disk has bad sectors.',13,10,'$'
FMT_HOW: DB 'Press Y for normal or A for enhanced (1.5) density',13,10,'$'
ASK_FMT: DB 'Do you want to format the Atari disk? (Y/N)',13,10,'$'
SA_DWRITE: DB 'Write disk image to an Atari Disk ...',13,10,'$'
NOT_RDSK: DB 'Disk image must be a RAMDISK',13,10,'$'
Q_DO_ALL: DB 'Press 1 to write entire disk; 2 to specify sector range',13,10
        DB '$'

; Below variables & strings imported from EPROM.S to make use of the
; DEBUG screen style data printout:


EP_ADR  DW 0 ; current EPROM address being accessed
; A line to contain hex data for a "DEBUG" style printout:

HLADR:   DB '0000  '       ; Page goes here
HLHX:   DB '00 00 00 00 00 00 00 00 ' ; 8 hex digits
        DB ' '          ; separator
        DB '00 00 00 00 00 00 00 00  '; 8 more hex digits plus separator
HLTXT:  DB '                ' ; Space for ascii representation
E_HL:   DB 13,10,'$'          ; end of line marker
CHAR_PT DW 0    ; pointer to hex character field
MARKER DB '~' ; character to substitute for unprintable char
SKWAIT: DB 13,10,13,10,'Press any key (Q to quit)', 13,10,13,10,'$'
QPSDTS: DB 'Put sector data to screen? (Y/N) (Note: see 361-368 for DIR info)'
        DB 13,10,'$'
PSD_CH DB 'N' ; Put sector data to screen? (yes, no)
;
; *************************************************************************

	DB 'ATTRIBUTE VALUES FOR SCREEN COLORS FOLLOW'
ATTR1   DB 07h   ; white on black: Normal background
ATTR2   DB 017h   ; white on blue: Title line
ATTR3   DB 02h   ; green on black: Menu box outline
ATTR4   DB 071h   ; blue on white: Menu box contents
ATTR5   DB 07h  ; white on black: first part of disk status line
ATTR6   DB 04h  ; red on black for ramdisk changed/not saved
ATTR7   DB 07h  ; white on black for ramdisk not changed
ATTR8   DB 02h  ; green on black for file access disk
ATTR8B	DB 082h	; same as above, blinking
ATTR9   DB 0Eh  ; yellow on black: NORMAL status messages
ATTR10  DB 0Dh  ; violet on black (bright): ERROR status messages
ATTR11  DB 07h  ; white on black: STATUS line field names
ATTR12  DB 05h  ; violet on black (normal): STATUS LINE field entries
ATTR13  DB 03Eh  ; yellow on cyan: User fields within menu box
INV_ATTR DB 70h ; attribute for inverse video (highlighting fields)
; note that normal ATTR is ATTR1

COLOR   DB 0FFh ; <> 0 means display is in color

        DB 'CRC FOLLOWS:'
CRCA:
CRC     DW 054DFh; FOR VIRUS CHECK: REV. 3.03 also used by HOWFAST
CAL_CRCA:
CAL_CRC DW 0; Place for the calculated CRC
VHANDLE DW 0; file handle for sio2pc.com

; rev 3.08:

SBAD_CRC:
 DB 'CRC CHECK BAD: POSSIBLE VIRUS INFECTION OR PROGRAM HAS BEEN ALTERED!'
 DB 13,10,13,10,'$'
SBAD_CRCA:
 DB 'SIO2PC has a self check for virus detection.  Alterations to the'
 DB ' program',13,10
 DB 'cause it to give this warning.'
 DB 13,10,13,10
 DB 'You may choose to change SIO2PC',39,'s CRC value if you wish,'
 DB ' so this message '
 DB 13,10
 DB 'won',39,'t be displayed again. However, this WON',39,'T remove '
 DB 'any virus which'
 DB 13,10
 DB 'may exist. Validate or erase the program '
 DB 'if you don',39,'t know what caused the',13,10,'bad CRC.'
 DB 13,10,13,10
 DB 'Enter ',39,'OK',39,' to change the file',39,'s CRC. Any other '
 DB 'key to NOT alter the file.',13,10,'$'

COMMENT\
BDAY:
 DB 13,10,13,10
 DB 'SIO2PC - VIRUS WARNING:',13,10,13,10
 DB 'Your system has become afflicted by the dreaded 19-Sept-96 virus',13,10
 DB 'which causes the user to start acting like a geezer or worse.',13,10
 DB 13,10
 DB 'To correct, select a later date of birth!',13,10,13,10,'$'
BDAY2:
 DB 'Happy Birthday, Charley ... You have given more gray hairs than',13,10
 DB 'you',39,'ve gotten.',13,10,13,10,'$'
ENDOFCOMMENT\

;               TIME DELAY STRINGS:

TMENU:	 DB 13,10,'                   TIMING & OPTIONS MENU',13,10,13,10
	DB ' TIME           DESCRIPTION        DEFAULT          CURRENT'
	DB 13,10,13,10
ST1:	 DB ' T1: Time before 1st ACK             0300            0300'
	DB 13,10
ST2:	 DB ' T2: Time before 2nd ACK *           0FA0            04B0'
	DB 13,10
ST3:	 DB ' T3: Time before COMPLETE *          0300            012C'
	DB 13,10
ST4:	 DB ' T4: Time before COMPLETE **         0300            012C'
	DB 13,10
ST5:	 DB ' T5: Time after COMPLETE **          0300            01F4'
	DB 13,10
ST6:     DB ' T6: Time between data bytes **      0000            0000'
	DB 13,10
ST7:     DB ' T7: Time between UART accesses      0008            0008'
	DB 13,10
ST9:     DB ' T8: Time between printer records    0000            0000'
	DB 13,10,13,10
        DB '  C: Change Disk Configuration',13,10
	DB '  T: Toggle sense of command line input',13,10
        DB '  D: Enter 1050-2-PC disk drive interface mode',13,10
        DB '  G: Hardware Diagnostics Sub-Menu'
	DB 13,10,13,10
	DB '     *  Data frame from Atari to PC',13,10
	DB '    **  Data frame from PC To Atari',13,10,13,10
ST8:     DB 13,10
	DB ' Enter item to change [1 thru 8, C, T, D]:'
	DB 13,10,'  (Any other key returns to SIO2PC)',13,10,'$'

QD_TYPE: DB 13,10,'1) Create header for SIO2PC compatibility.',13,10
	 DB '2) Create disk image file without header.',13,10,'$'
DO_CPTK: DB 'Simulate copy protected disk? (Y/N)',13,10,'$'
WANT_CPTK: DB 'N' ; Y means answer to above was yes
W_WPRTK: DB 'Simulate write protected disk? (Y/N)',13,10,'$'
DG_STATUS: DB 0,020h,0FFh,010h ; temp storage for good status
D_NMEM	 DB 'Not enough memory to buffer disk track(s)',13,10,'$'
D_DONE   DB 'Requested action is complete.  Press any Key',13,10,'$'
GUD_FOUND DB 'N' ; flag good sector has been found


CUR_DSTS DB 'Current status of disks (Configurable, Y/N):',13,10,'$'
ENT_NCH DB 'Enter number of disk to change its configurability status,'
        DB 13,10, 'any other key to quit this function:  $'

ENTER4:  DB 'Please enter 4 Hex digits: $'
HEX_PLACE: DB '0000'; Place to store 4 ASCII hex digits

; A table of offsets into the "current value" field of the time fields

STROFS  DW ST1 + 53
        DW ST2 + 53
        DW ST3 + 53
        DW ST4 + 53
        DW ST5 + 53
        DW ST6 + 53
        DW ST7 + 53
        DW ST9 + 53

M_DIAG:
 DB 13,10,13,10
 DB ' This function tests the communications connections to/from the',13,10
 DB ' Atari.  Run DIAGS.OBJ on the Atari to put it into the same mode'
 DB 13,10,13,10
 DB ' 1) Enter Intercom Mode',13,10
 DB ' 2) Line Status Troubleshooting',13,10
 DB ' 3) Sector I/O with Atari',13,10
 DB ' 4) N/A',13,10
 DB ' 5) Exit Diagnostics Sub-Menu',13,10
 DB '$'

; below is data for sector trials, 16 bytes to be sent 8 times for a
; sector

S_DATA:
        DB 10101010XB, 01010101XB, 11111111XB, 00000000XB
        DB 11101111XB, 11111011XB, 00001000XB, 10000000XB
        DB 00000001XB, 11111110XB, 01111111XB, 11001100XB
        DB 00011100XB, 01111111XB, 11111110XB, 00100101XB

M_LINES:
	DB 13,10,13,10
	DB 'Serial Port Line Status Mode ...',13,10,13,10
	DB 'Command:',13,10
        DB 'Data Out:',13,10 ; put in row 5, col 10
	DB 'Data In:',13,10,13,10
        DB 'Press O to toggle DATA OUT line status.',13,10
        DB 'Press I to reset DATA IN status to high',13,10,13,10
        DB '(Note: PC can detect DATA IN line transition to low,',13,10
        DB ' but cannot detect its return to the high state.)',13,10,13,10
	DB 'Press Escape to exit this function.',13,10
	DB '$'

OUTNOW DB ' '
CMD_LAS DB ' '
NUMSECS:
        DB 'Sector I/O Test - Press a key to cancel or when finished'
        DB 13,10,'$'

; DS_FLD is diagnostics / sector field.  16 chars long allows 5 per line,
; 125 per page, with 11 specific character codes for errors / statuses
        DB '  '; these 2 bytes for INT2DEC to overflow into when filling nnn
DS_FLD: DB 'nnn *********** '
DS_SCRN DW 0 ; pointer to screen offset for next write of above
DS_SIZE DW 128 ; size of sector  for diags routines

HEAD1050:
DB '  Ŀ',13,10
DB '                      1050-2-PC MODE                            ',13,10
DB '                                                                ',13,10
DB '   This mode allows the PC to connect to Atari disk drives      ',13,10
DB '   directly and read or write information.  Separate hardware   ',13,10
DB '   is required.  The SIO2PC hardware cannot be connected to an  ',13,10
DB '   Atari drive and used for this function.                      ',13,10
DB '  ',13,10
DB 13,10,13,10
DB 'Choose Option:',13,10,13,10
DB ' 1)  Read 720 sector standard disk to file',13,10
DB ' 2)  Read 1040 sector 1050 disk to file',13,10
DB ' 3)  Write disk image to the Atari disk drive',13,10
DB ' 4)  Read a specified block of sectors to a file',13,10
DB ' 5)  Format an Atari disk',13,10
DB ' 6)  Scan sectors for status & errors and/or view sector data',13,10
DB ' X)  Exit 1050-2-PC mode and return to SIO2PC',13,10

DB '$'
SA_RDSEC: DB 'Reading Sector number(s):',13,10,13,10,'$'
A_SNUM: DB '     $' ; INT2DEC will put sector number string here ...
D_AS_CT DB 0 ; counter for printing sector numbers across screen ...
DA_SEC: DB 'SECTOR #' ; for disk scan info to screen/printer
DA_SPLC: DB '     : $' ; put the sector # here
;DA_CFERR: DB 'Command frame did not go to completion$'
; Space for Command Frame 5 bytes by name:
; in reverse order as received
DA_STFRAME: DB '  STATUS BYTES: '
DA_STFRX:   DB '00 00 00 00$';,13,10,'$'; Routine will put ascii bytes here
WS_FAIL: DB 13,10,'Sector write failed, #'
WS_FNBR: DB '     ',13,10,'$'
SA_WSEC: DB 'Writing sectors ...',13,10,'$'

; ******** COPY PROTECTED DISK INFORMATION *************
;
; for a disk image with the copy protected flag set, if the first 32 bits
; of sector data for any sector is as below, that means "bad sector"
; additional following data will tell disk status, etc.

; D_CPTK: DW 1CC2h, 1E3Dh ; this 32 bit identifier decided by coin flips

; below is an EQUATE version for immediate mode:

CP_WHI EQU 1CC2h ; occupies 1st word of sector info
CP_WLO EQU 1E3Dh ;    "     2nd  "        "      "


CFCKSM	DB ?
CFAUX2	DB ?
CFAUX1	DB ?
CMND	DB ?
DEVID	DB ?

; Store hardware registers for serial chip:

BAUD    DW ? ; DLAB (LSR b7) = 1, address BAUD; = 0, R/W data
INT_EN	DW ? ; When DLAB=0, else (= 0) - high byte of BAUD
INT_IDENT DW ?
LCR	DW ? ; Line control register
MCR     DW ? ; Modem control register
MSR	DW ? ; Modem status register
LSR	DW ? ; Line status register
COM_NO DB  ? ; This is set by user choice to 0 for Port 1
	     ; or 2 for port 2.

BLANK	DB 0 ; 0 means not blanked
SAY_BLANK: DB 'SCREEN BLANKED - PRESS ESCAPE TO RESTORE$'
;
; ******** VARIABLES & STRINGS FOR THE DOS SHELL FEATURE **********

; Notice: this was more than a little tricky -
; Ending COMMAND.COM string with a space, then 0, was a necessity.
; Having the command tail of 0, 0Dh, pointed to by the parameter
; block was also necessary, or else COMMAND.COM reports that it
; can't find the search directory and loses its environment.


SHELLSPEC:  DB 'C:\COMMAND.COM'; gets overwritten by GET_SPEC
            DB 0
; below: space for larger comspec path
	    DB '                                               '
	    DB '                                         '
	    DB 0
CSTRING:    DB 'COMSPEC=' ; string to search for in env. string
STORE_SP    DW 0  ; place to keep SP during EXEC
STORE_SS    DW 0  ; place for SS
TYPE_EXIT   DB 0DH, 0AH,'Type EXIT to return to SIO2PC$'
BAD_MEMAL:  DB 'Memory alloc function 4Ah, error # $'
FLAG_BM     DB 0 ; 0 means no error occurred in function 4Ah
BAD_SHELL:  DB 'Error in EXEC function 4Bh$'
CMND_TAIL:  DB 0,0Dh

FCB1:   DB 32 DUP (0)
FCB2:   DB 32 DUP (0)
MEM_ALLOC DW 0 ; used by FREE_MEM to keep old memory allocation
NOT_LAST: DB 'Error: SIO2PC memory not last in chain$'

; Note: segments below filled in at run time

PAR_BLOCK:
        DW 0    ; Segment pointer to env. block
        DW CMND_TAIL; Offset of command tail
CTS     DW 0    ; Segment of command tail
        DW FCB1 ; Offset of first FCB
PBS1    DW 0    ; Segment, 1st FCB
        DW FCB2 ; Offset, 2nd FCB
PBS2    DW 0    ; Segment, 2nd FCB


;		RAMDISK VARIABLES

DVSEG	DW ?	; Segment to address Ramdisk
SECTOR	DW ?	; Sector # as received from Atari
NEXTS	DW ? ; Next available segment, w/offset = 0.
DISK    DB ? ; Disk currently being used or setup '0' - '8'
DISKW DB  ? ; Above number times 2 for word address.
SECBUF: DB 256 DUP (?); Holding buffer for sector data
SIZE_CH DB  ?; User's size choice input as 0 to max - 1.
DELSIZE DW ? ; Size of ramdisk being deleted by DELETE
DMOVSIZE DW ?; Size of ramdisk being relocated by DELETE
DUN_BLANK DB 0; NON "0" means blank disk created but not written
		; so no need for format to write all 0's on it
		; again.
RAM     DW 0    ; amount of free RAM in paragraphs, used by PUT_RAM
REMAIN  DW 0    ; save remainder. Used by USE_4K

;		VIDEO VARIABLES
;
; NOTE: see below attribute bytes for the COLOR flag
;
VPAGE	DB ? ; Video page
CURSOR	DW ? ; High = row (0 -24) Low = col (0 -79)
	     ; (as read, not as stored)
SCR_SEG DW ? ; Segment for screen data


;		MISC VARIABLES

TAIL_PT DB  ? ; Pointer to next byte in command tail
;	        user must init to 081h.
TAIL_CNT DB  ? ; First entry in tail. Init to value
	       ; at CS:080h
LOCK_RTS DB ?  ; 0: Not locked, else locked to enable
VALID   DB 0    ; 0 means not valid SIO2PC device

;   *************** INTERRUPT ROUTINE VARIABLES *****************

; Storage for as found values for INT 0Bh and INT 0Ch

; INT_B is IRQ3 and COM 2 & 4
; INT_C is IRQ4 and COM 1 & 3

INT_B   DW 0,0  ; First word: offset, 2nd: segment
INT_C   DW 0,0

; Variables, label, for timer 0 redirection for MYVEC8 routine

VARBL   DW 0; This number will be decremented by timer 0 until 0

; **** PROGRAMMING NOTE: MAKING A LABEL = STORED ADDRESS: ***


@CONTIN:
CONTIN  DW 0 ; Segment address of the old interrupt routine
H_CONTIN DW 0

CRITIC  DB 0; Critical error ignored: 0 = no, <>0 means YES
CTRL_C  DB 0; NEWV23 int routine sets this to 0FFh
ASS_SIZE: DB 'Choose standard sizes from list (Enter Choice:)$'

SS_SIZES:

DB 'Choice   Sides  Tracks  Secs/Trk  KBytes  Sectors',13,10,13,10
DB '  1        1      35       18        79     630',13,10
DB '  2        1      35       26       114     910',13,10
DB '  3        2      35       18       157    1260',13,10
DB '  4        2      35       26       227    1820',13,10
DB '  5        1      40       18        90     720',13,10
DB '  6        1      40       26       130    1040',13,10
DB '  7        1      77       26       250    2002',13,10
DB '  8        2      77       26       500    4004',13,10
DB '  9        1      80       18       180    1440',13,10
DB '  A        1      80       26       260    2080',13,10
DB '  B        2      80       18       360    2880',13,10
DB '  C        2      80       26       520    4160',13,10
DB 13,10,'$'

; REV 4.21 - 4160 in C above was 8200 (text info string only, though)

DS_SIZES:
DB 'Choice   Sides  Tracks  Secs/Trk  KBytes  Sectors',13,10,13,10
DB '  1        1      35       18       157     630',13,10
DB '  2        2      35       18       315    1260',13,10
DB '  3        1      40       18       180     720',13,10
DB '  4        1      77       26       500    2002',13,10
DB '  5        2      77       26      1000    4004',13,10
DB '  6        1      80       18       360    1440',13,10
DB '  7        2      80       18       720    2880',13,10
DB 13,10,'$'

SN_SECTS: DW 630, 910, 1260, 1820, 720, 1040, 2002, 4004
	  DW 1440, 2080, 2880, 4160

DN_SECTS: DW 630, 1260, 720, 2002, 4004, 1440, 2880
; rev 3.01A
; Conversion tables for # of paragraphs to #TRACKS, #SIDES
; #SECTORS/TRACK

; SPARAS table of sizes in paragraphs for single density

SPARAS: DD 013B0h, 01C70h, 02760h, 038E0h, 01680h, 02080h
	DD 03E90h, 07D20h, 02D00h, 04100h, 05A00h, 08200h

DPARAS: DD 02748h, 04EA8h, 02CE8h, 07D08h, 0FA28h, 059E8h
	DD 0B3E8h

; paramaters for single density:

STRACKS: DB 35,35,35,35,40,40,77,77,80,80,80,80
SSECS:	 DB 18,26,18,26,18,26,26,26,18,26,18,26
SSIDES:  DB 0,0,1,1,0,0,0,1,0,0,1,1

; Parameters for double density

DSTRACKS: DB 35,35,40,77,77,80,80
DSSECS:   DB 18,18,18,26,26,18,18
DSSIDES:  DB 0,1,0,0,1,0,1

CFG_PTR DW 0; PLACE TO SAVE THE POINTER


; the following 12 byte area is for the disk configuration
; information used by advanced DOS's and drives.
;
; This is a staging area for information to be moved into and
; out of the same fields of the four disk records

; Rev. 4.21 Note:  CFG2/3 should get MAX_SEX only if CFG0 is set equal
; to 1.  If CFG0 is set to actual number of tracks/side (from my table of
; standard sizes), then CFG2/3 should get SECS_TRAK--actual sectors per
; track.  Says Erhard Puetz

CFG0    DB 0    ; tracks per side
CFG1    DB 0    ; drive step rate
CFG2    DB 0    ; sectors/track high byte (hi part of MAX_SEX)
CFG3    DB 0    ; low part
CFG4    DB 0    ; double/single sided
CFG5    DB 0    ; type code
CFG6    DB 0    ; high of bytes of bytes/sector (hi part SEC_SIZE)
CFG7    DB 0    ; low
CFG8    DB 0    ; translation control
CFG9    DB 0,0,0        ; three spare bytes



; TABLES FOR VARIABLES FOR FOUR RAMDISKS:

; The tables will work like this: The DISK variable will
; index into the DSK_PTR pointers, which will contain 
; the offsets of BLOCK1,2,3,4, but not necessarily in 
; that order. For addressing a certain variable, the
; name [e.g. - HANDLE], plus an index [BP], will be
; used. The index will be loaded from the DSK_PTR table.
; To swap the identities of two disks, the values in the
; DSK_PTR entries will just be swapped, effectively
; switching the numbers of the two disks.


HANDLE:  DW 0 ; File handle as supplied by dos;

; the following 12 bytes are to support the GET/SET configuration
; options of MYDOS 4.5 and other advanced DOS's.

TRACKS_SIDE: DB 1       ; tracks per side
STEP_RATE:  DB 1       ; this is a wild guess
SECS_TRAK:  DW 0        ; note: send out in reverse order

; the  WORD above is max # of sectors
; actually, it's supposed to be sectors per track, but MYDOS does
; big disks by saying there's one track and it contains all the
; sectors. MYDOS expects to receive MAX_SEX and the sector size
; word both as high byte first


SIDE_CODE: DB 0          ; 0 means single sided, 1: double
TYPE_CODE: DB 00000000xB  ; b2=1 for DD; b0=1 for 8 inch diskette
SEC_SIZE: DW 080h        ; Number of bytes per sector. NOTE: send
			; out in reverse order, hi byte first

; Translation control below:

	; b7=1: 40 track disk I/O on an 80 track drive
	; b6=1: drive present (always 1)
	; b1=1: handle sectors 1,2,3 as full size (SIO2PC CAN'T DO)
	; b0=1: sector #'s start with 0, not 1 (SIO2PC CAN'T DO)

TRANS_CTRL: DB 01000000xB
SPARE10_12: DB 0,0,0     ; three spare bytes
MAX_SEX: DW 0   ; maximum # of sectors
DSK_FLAGS: DB 00000000xB
; b0=1: don't clear filedsk on format
; b1=1: don't accept GET/SEND CONFIG commands

; b2=1; don't clear after read complete (SIM DISK ONLY)
; b3=1; sim disk is a BOOT disk
; b4=1; copy protected disk; from D_D_INFO in file header
; b5=1; write protected disk image
; b6=1; sim disk is SPARTA format

HI_SIZE: DW 0; Hi part of SIZE stored here; REV 3.00 added
LO_SIZE:   DW 0; Size of this drive in paragraphs; see also HI_SIZE
STARS:   DW 0; Starting segment for disk
SEC_PTR: DW 0; Pointer into FILE, for file access REV. 3.00
VMAX_SEX DW 0; variable, simulated disk routine decrements this
STATS:   DB 0,020h,0FFh,010h ; STATUS, in reverse order, 3,2,1,0
SIM_ENTRY: DB 00000010Xb, 200, 1; 3.10 unlocked file (b5); 3.17 added :
        DW 401; starting sector #; 3.10: was DB 100, 0
SIM_FN: DB '        ', '   ' ; 3.17 added :
S_DISK:  DB 'DISK '
N_DISK:  DB '   '; ascii disk # plus colon here (there's 1 space too)
ADSKSZ:  DB '        '; ASCII char size of rdsk in K 5 digits & "K, "
ADENS:   DB '    '; Density: SD or DD.  "SD, "

; REV 3.00: for the WRITTN variable below, W means the ramdisk has
; been written to by the Atari ( therefore needs to be saved ), N means
; it hasn't ( or physical file has been updated to match ramdisk), F
; means the disk image is a physical file, not a ramdisk ( therefore
; updating the physical file is automatic) 'S' means the disk is a
; simulated disk (DOS 2 type).  'B' for boot type simulated disk.
; [SPACE] means this disk doesn't exist.

WRITTN:  DB '   '; 'W, ' if has been written,'N' if not, 'F' for file
F_SPEC:  DB 55 DUP (0); 55 CHARS for filespec (incl. 0)
DOLL:    DB '$'; Mark end of ascii string
TIME_G: DB 0 ; for cptk disks; time delay after good read/write (jiffies)
TIME_B: DB 0 ; time delay after bad read or write (jiffies)

B_STATUS: DB 0,0,0,0 ; status bytes for a bad sector - 4.01
B_STAT DB 0 ; 0 means report good status, <> 0 means use above bad stat
G_STATUS: DB 0,020h,0FFh,010h
MARK_END:
; status for good sector (4.05) [might be non-std]

; Now, duplicate for other 4 disks:
; rev 3.04: the 5th "disk" is for access to file disks
; for the SPARTA dir decode and possible future uses.
; 4.11 the 6th disk is just an undisturbed copy to be used
; to restore the others when a disk is uninstalled ...

MORE_DSKS MACRO

        DW 0; HANDLE

        DB 1 ; TRACKS_SIDE
        DB 1 ; STEP_RATE

        DW 0 ; SECS_TRAK
        DB 0 ; SIDE_CODE
        DB 00000000xB ; TYPE CODE
        DW 080h ; SEC_SIZE
        DB 01000000xB ; TRANS_CTRL
        DB 0,0,0 ; SPART10_12
        DW 0; MAX_SEX
        DB 00000000xB ; DSK_FLAGS
        DW 0 ; HI_SIZE
        DW 0 ; LO_SIZE
        DW 0 ; STARS
        DW 0 ; SEC_PTR
        DW 0; variable, simulated disk routine decrements this
	DB 0,020h,0FFh,010h; Rev 1.06 changed timeout to 020h
        DB 00000010Xb, 200, 1; SIM_ENTRY 3.10
        DW 401
        DB '        ', '   '; SIM_FN
        DB 'DISK'      ; S_DISK
        DB 19 DUP (' ') ; N_DISK, ADSKSZ, ADENS, WRITTN
        DB 55 DUP (0) ;; F_SPEC
	DB '$'
        DB 0, 0 ; TIME_G & TIME_B
        DB 0,0,0,0,0 ;; B_STATUS (4 bytes) and B_STAT
        DB 0,020h, 0FFh, 010h; (G_STATUS)
        #EM

        MORE_DSKS
        MORE_DSKS
        MORE_DSKS
        MORE_DSKS
GOOD_COPY:
        MORE_DSKS


; Making assembler compute block size is a *** 1.06 *** change

BLOCK_SIZE EQU MARK_END - HANDLE ; For setting base addrs of BLOCKS.

; Text messages:


TTL1:    DB 13,10,'SIO2PC: an Atari to PC interface by Nick Kennedy'
        DB 13,10
        DB 10,13,10,13,'  300 South Vancouver St.',10,13,'  Russellville, '
        DB 'Arkansas, 72801',10,13,10,13
        DB 'email: nkennedy@tcainternet.com',10,13
        DB 'Web Site: www.cswnet.com/~nkennedy/',10,13,10,13
        DB 13,10,13,10

         DB 'VIRUS CHECK INFO: FILE SIZE MUST BE '
SAY_SIZE: DB '21174 bytes',10,13,10,13
        DB 'Additional commands not on menu:',13,10
        DB '  B - Blank Screen (toggle)',13,10
        DB '  Z - Sound On/Off (toggle)',13,10,13,10
        DB 'CRC: '
SCRC    DB '0000h',10,13,'$'

EVCF    DB 'ERROR VIRUS CHECKING FILE. VIRUS CHECK ABORTED$'
VW_LEN  DB 'VIRUS WARNING: PROGRAM SIZE IS     '
SAY_VLN DB '  BYTES LONGER THAN EXPECTED$'
SGOOD_CRC DB 'CRC CHECK O.K.$'
NO_VMEM DB 'NOT ENOUGH MEMORY FOR VIRUS CHECK$'

TX1:     DB 'SIO2PC 4.21'
TX1A    DB ' : An Atari to PC Interface System$'

TX2:     DB 'Enter configuration information:$'
TX3:     DB 'C - CREATE ATARI DISK IMAGE$'
TX35:    DB 'I - INSTALL PC FILE AS DISK$'
TX4:     DB 'L - LOAD DISK IMAGE FROM FILE$'
TX5:     DB 'W - WRITE DISK IMAGE TO FILE$'
TX7:     DB 'S - SET PORT NUMBER: '
ACOMN:   DB '?$'; Program will fill in # for ?.

TX8:     DB 'T - TOGGLE STATUS LINE$'
TX9:     DB 'Q - QUIT PROGRAM$'
TX9A    DB 'J - JUMP TO ULTRA SPEED (TOGGLE)$'
TX10:    DB 'X - EXCHANGE DISK I.D. NUMBERS$'
TX11:    DB 'Enter first number: $'
TX12:    DB 'Enter second number: $'
TX14:    DB 'K - LOCK DATA LINE: ('
LOCKSTAT: DB ' AUTO )$'
OPT2:    DB 'E - ENTER HEX ADDRESS: '
CMTXT:   DB 'xxxx$'; Program will put actual address used where ?'s are.
OPT3:    DB 'H - EXIT TO DOS SHELL$'; 3.08: WAS "RESTORE SCREEN MENU"
OPT4:    DB 'D - DISPLAY DIRECTORY$'
OPT5:    DB 'P - PRINT_THRU: $'
PFLD_CURS EQU 083Ch; cursor position for print_thru info
OPT5A:   DB 'ON$'
OPT5S:   DB ', S$'      ; SCREEN
OPT5P:   DB ', P$'      ; PRINTER
OPT5F:   DB ', F$'      ; FILE
OPT5B:   DB ', X$'      ; EOL CONVERT
OPT5C:   DB ', 7$'
OPT5D:   DB ', LF$'
OPT5E:  DB ', T$'
OPT6:    DB 'U - UNINSTALL DISK$'
OPT7:    DB 'A - ALTER BUS TIMING VALUES$'

STNORM:  DB ' AUTO '
STLOCKD: DB 'LOCKED'

QADRS:   DB 'Enter address: $'
RUNNG:   DB 'Disk Emulator is running.$'
VOR:     DB 'Value out of range.$'
X10:     DB 'This disk # already exists. Renumber or uninstall.$'
X11:	 DB 'Not enough memory for ramdisk. '
X111:	 DB 'Using file access.$'
QUITW?:  DB 'Ramdisks changed. "Q" to quit, any other key to cancel$'
NOT_SAVED: DB 'Ramdisk not saved. "Y" delete anyway, "N" abort command$'
BADLCR:  DB "UART DOESN'T READ BACK. POSSIBLE PORT ADR. ERROR.$"
NOLOOP:  DB 'UART FAILED LOOPBACK TEST. POSSIBLE PORT PROBLEM.$'
GET_DSIZE: DB  'ENTER 1/64K, 2/92K, 3/133K, 4/184K, 5/CUSTOM, 6/MORE$'
CUSTOM:  DB 'ENTER SIZE (DECIMAL) IN SECTORS (65535 MAXIMUM): $'
DISKFULL: DB '*** ERROR: DISK MAY BE FULL - TERMINATING PRINT_THRU MODE ***$'

SCRITIC: DB 'Hardware error, INT 024h status: '
CRIT_STAT DW 0
	DB 13,10
	DB 'Check disk drive and/or printer & correct problem',13,10,'$'
SCRITIC2: DB 'Press "I" to ignore error and continue,',13,10
	DB 'Press "R" to retry DOS function and continue,',13,10
	DB 'Press "E" to exit SIO2PC and return to DOS.$'

ADSZ1:   DB ' 64K, '
	DB ' 92K, '
	DB '133K, '
	DB '184K, '
USRSZ:  DB '      '     ; REV 3.00: was 'CPTK'
MAXDEC  DB 6            ; max digits to input into DECIMAL incl CR
ACTDEC  DB 0            ; number actually read into DECIMAL
DECIMAL: DB '00000',0    ; User inputs custom size string here
			; will be copied to USRSZ
WRONG_SX: DB 'Warning: actual # of sectors is ####'
WSX_PTR: DB '#$'
WRONG_DNS: DB 'Warning: Density selection doesn', 39, 't match actual$'

ASZ_PTR: DW 0,6,12,18,24; Offsets into strings from ADSZ1

ASDNS:   DB 'SD, '; Offsets for these calculated from
	DB 'DD, '; SEC_SIZE.
CCRUD   DB ' '  ; Command letter from user's menu choice.
XCRUD   DB ' '  ; Same, but doesn't get altered by
OPT_CNT DB 0 ; How many options entered?
SLASHES: DB 'Press ...',13,10
         DB ' P to force physical file access ',10,13
         DB ' N to skip clearing file disk on formatting',13,10
         DB ' Enter when finished with options$'
DDNE:    DB 'This RAMDISK does not exist.$'
QUEFS:	 DB 'Use existing file spec? (Y/N)$'; 3.17 added (Y/N)
EOPF:    DB 'ERROR opening file. DOS Error code = $'
FARE:    DB 'This file already exists. OK to overwrite? (Y/N)$'
ECF:     DB 'Error creating file. DOS Error code = $'
ALLUSED: DB 'All disk control blocks in use. (4 maximum)$'
PARTW:   DB 'Partial record written. Disk may be full.$'
EWF:     DB 'ERROR in writing file. Correct and retry.$'
EWF1:    DB 'ERROR writing file. Transfer aborted.$'
FTCPT:   DB 'FILE TRANSFER COMPLETED.$'
F2PCIP:  DB 'FILE TRANSFER MODE. PRESS ESCAPE TO CANCEL.$'
CRAMD:   DB 'CREATING RAMDISK:$'
D_OR_S DB 'Enter S or D for SINGLE or DOUBLE density$'
CHPN:    DB 'CHOOSING PORT NUMBER:$'
PRMT_COM: DB  'PLEASE ENTER # OF COM PORT TO USE (1 - 4)$'
PRMT_DSK: DB  'PLEASE ENTER # OF RAMDISK (1 - 8), ESC to cancel.$'
ERRRF:   DB 'ERROR READING FILE $'
ESFP:    DB 'ERROR SETTING FILE PTR (FUNC 42h) AX = $'
EWTF:    DB 'Error writing file (FUNC 40h) AX = $'
KEYWAIT: DB 'Press any key to continue$'
KEYWAITE: DB 'Press any key to continue or ESC to quit$',13,10
ECLOSE:  DB 'Error closing file. (FUNC 3Eh) AX = $'
NO_WRITE: DB 'Physical disk file. Use UNINSTALL to close file. $'

;       DIRECTORY INFORMATION

; Character codes for screen box drawing MACROs:

; These are the double line values:

HORIZ: DB 205
VERT:  DB 186
TEE_UP: DB 202
TEE_DN: DB 203
URC:    DB 187  ; UPPER RIGHT CORNER
LRC:    DB 188
ULC:    DB 201
LLC:    DB 200
CROSS:  DB 206
TEE_RT: DB 204
TEE_LT: DB 185

; These are the single line values:

SINGLE: DB 196, 179, 193, 194, 191, 217, 218, 192, 197, 180

SING_SET EQU SINGLE - HORIZ

; COLOR DEFINITIONS:

BLACK EQU 0
BLUE EQU 1
GREEN EQU 2
CYAN EQU 3
RED EQU 4
MAGENTA EQU 5
BROWN EQU 6
WHITE EQU 7
GRAY EQU 8
LTBLUE EQU 9
LTGRN EQU 10
LTCYAN EQU 11
LTRED EQU 12
LTMAG EQU 13
YELLOW EQU 14
BRI_WH EQU 15

; INFO FOR PLACEMENT AND SIZE OF DIRECTOR LIST BOX:

DB_ROW  EQU 1
DB_COL  EQU 5
DB_WIDE EQU 17
DB_HIGH EQU 24
DB_SET  EQU 0

WHATSPEC: DB 'Enter search spec or just ENTER to cancel.', 13,10,13,10
        DB 'Examples:',13,10,13,10
        DB '  A:*.*',13,10,'  ..\*.AT?',13,10,'  C:\ATARI\*.*'
        DB 13,10,'  *.*',13,10,13,10,'$'
BAD_DRIVE: DB 13,10,'Drive Change Function Failed.  Press a Key',13,10,'$'
OLDRIVE: DB 'C:\' ; Continues on to OLDPATH. 4.11 added backslash
OLDPATH: DB  64 DUP (0)
NEWDRIVE: DB 'C:\' ; Continues on to NEWPATH. 4.11 added backslash
NEWPATH: DB 64 DUP (0)
FILENAME: DB '*.*', 9 DUP (0) ; 11 plus 0
CAN_DIR: DB '[  CANCEL   ]' ; my fields are 13 spaces long
TYPE_IT: DB '[ TYPE SPEC ]'
PATH_NG: DB 'Invalid path error.  Enter new search spec',13,10,'$'
START_PT DW 0 ; starting search point for 1 key entry select - ES:adr
NXT_DRAM DW 0 ; Pointer to next place in ram to store/access dir entry
SELECTED DB 0 ; # of field selected in list box; range is 0 to 21
WIN_S DW 0 ; address of 1st field in window in seg NEXTS
WIN_F DW 0 ; adr of last field, = WIN_S + 13 * 20
TOTALD  DW 0 ; total entries in list.  Range 0 to total number - 1
TOP_NOW DW 0 ; number of selection which is at top of list, range 0 to
             ; TOTALD
DID_BS DB 0 ; flag bubble sort did toggle two entries; 0 means did not

; Below is for the PRINT_LM macro, which prints directly to the screen
; with a specified left margin.  13 goes to the next line and 10 ends the
; string being printed.

DROPSAY:
        DB 'Select the desired file or directory and press Enter.',13
        DB 'Use arrow keys and page up / page down to navigate.',13,13
        DB 'Use [ TYPE SPEC ] (or SPACEBAR) to manually enter a', 13
        db 'drive, path, search spec or combinations of these.',13,13
        DB 'Examples:',13,13
        DB 'C:            \ATARI\*.ATR    A:\*.',13
        DB '..\ATDIR\     *.*             *.AT?',13,13
        DB 'Directory spec without search spec should',13
        DB 'end with a backslash.',13,13
        DB 'NOTE: Search specs with extensions usually won',39,'t',13
        DB 'find directories.  Use *.* or *. to find dirs',10


; The 64 below tells DOS how many characters to input; the 0
; will be replaced by DOS with actual number input by funct. 0Ah
; (does not include CR)

DPTHHDR: DB 64,0; Header for below: max size (64), actual (by DOS)
DIRPATH: DB 65 DUP (0); Path to be searched for directory
CUR_DRIVE: DB 0; Numeric desig. for current drive from funct. 19h
BADPATH:  DB 'PATH ERROR; RETRY OR JUST "ENTER" TO CANCEL$'
ERRDIR:  DB 13,10,'Error in directory process; press any key',13,10,'$'
DIR_FIRST: DB 13,10,'ENTER "1" FOR PC DIR'
	DB 13,10,13,10,'ENTER "2" TO EXTRACT ATARI DIR',13,10,'$'
ENT_IMG: DB 'ENTER Atari image file search spec. EXAMPLE \ATARI\GAMES.ATR'
	DB 13,10,'  add ",P" for output to printer',13,10,'$'
DIR_INSTR: DB 'ENTER directory search spec. EXAMPLE: \ATARI\*.*',13,10,'$'
END_O_DIR: DB 13,10,'     End of search - Press any key$'
SEG_ODTA: DW 0; Segment of old (current) DTA
OFF_ODTA: DW 0; Offset     "

; DIRLINE field: 20 column field, to be printed 4 times, causing
; linefeed

DIRLINE: DB 1 DUP (' '); 1 space indent in 20 space field
DLPLUS5: DB 14 DUP (' '); Actual filename here, plus 2 blanks
DIRSPOT: DB 5 DUP (' '); write {dir} here when appropriate
DIRSTR: DB '{dir}'; To flag directory entries in above

; DTA below is a structure filled by DOS when a directory search is
; requested. Ref. DOS PROGRAMMER'S REF. PG 673

DIRDTA:  DB 21 DUP (0); These 21 bytes reserved for DOS
ATTDIR: DB 0; file attribute goes here, 0 for normal, 10h for DIR's
FTIME:   DW 0; Time file was created
FDATE:   DW 0; Date file was created
FSIZE:   DD 0000 ; File size
DIRFNAME: DB 'FILENAME.EXE',0; Filename as ASCIIZ goes here, 13 bytes total
DISK_TYPE DB 'R'; 'S' would mean SPARTA type disk; 3.04

DIR_RAM DW 0; a copy from RAM, for use by directory function
SPDIR DW 0; Offset of SPARTA directory data beginning
DIR_NEXT DW 0; Offset in free ram where next SPARTA sector goes

; A field for 16 byte Atari disk directory:

; 5 bytes info are status (B), length (W), start (W)
DIRBUF:  DB 0,0,0,0,0
ATNAM: DB 'FILENAME'
ATEXT: DB 'EXT'
	DB '    '; Pad of 4 so 6 * 16 fields = 80 columns
DOT: DB '.'
HANDL DW 0; Store handle for Atari disk image file
HANDLP: DW 0; Handle/flag for dir out to printer 0: no, 4: yes
D_HEADR: DB 16 DUP (0); Place to store disk image header
DIR_OF:  DB 13,10,'  Directory of: $'
CRLF:	 DB 13,10,'$'; For linefeed, use PRINTL CRLF; or call LINEFEED
DIR1  DB 0; Tells EXTRACT: first matching file when 0
N_SUBDIR DW 0; Number of subdir pointers pushed onto stack
			 ; used as a stack pointer
SDFLAG:  DB 0
SAY_SUB: DB '   Contents of subdirectory $'; Note: label following
; SAY_SUB is used to compute length of string.

; The subdirectory stack will work like this:

; N_SUBDIR will always be left pointing to the base of the next
; available stack entry minus 1. Therefore a value of 6*15 means
; stack full.  N_SUBDIR = -6 will mean the stack is empty. Since
; a stack entry is 3 words long, each push/pop will change N_SUBDIR
; by +/- 6.

; Now, set up a structure for the directory stack
; First comes the 0th entry, with names:

FILOSL:  DW 0; Low word of file offset for directory sector
FILOSH:  DW 0; same, high word
FIELD:   DW 0; field (entry #) of directory (0 to 63)

;Now, make 15 copies of above structure:

	DW 15 DUP (0)
MAIN_FLAG DW 0; 0 means current directory is MAIN (Spartados)

; Name stack for keeping subdirectory names. Feel free to
; use this area for other functions as well.

NAME_STACK: DB 32 DUP ('DIR_NAME')
N_STACK_PTR DW 0; range is 0 to 31*11; 3.17: was a label (:)
FIELD_COUNT  DB 0; Number of dir fields printed to screen since last
		; "press any key"

; below, first 16 bytes of sector 1 of a disk formatted by MYDOS
; as a DOS 2 SD 720 sector disk but not written to...

SECTOR_1: DB 04Dh, 03, 0, 07, 0E0h, 07, 04Ch, 014h, 07, 03, 0FFh
	DB 01, 0E9h, 01Bh, 00, 04

; first 16 bytes of sector 360, same as above

SEC_360: DB 02, 0C4h, 02, 0C4h, 02, 0,0,0,0,0Fh, 0FFh, 0FFh, 0FFh
	DB 0FFh, 0FFh, 0FFh

; INSTALL PC FILE DATA:

A_PCFILE: DB 'PC FILE'

SIM_DISK: DB 'Install PC file as simulated disk image...',13,10
        DB 'Press N for NO auto-uninstall after read'
        DB 13,10,'Press B to install simulated BOOT file',13,10
        DB 'Press Enter after desired options are selected$'

AT_START: DB 0FFh; non zero means file pointer is at start of file

; text fields for the STATUS line:

STAT_LINE: DB  'HDL: ' ; 4.11d changed LOC to HDL (file handle number)
LAST_LOC:  DB ' '        ; Last char put into location field
STAT_LOC: DB  ' CMND: '
CUR_CMND DB ' '
STAT_COM: DB  ' LAST: '
LAST_CMND DB ' '
STAT_LAST: DB ' DEV: '
LAST_DEVID: DW '  '       ; Last string put into LAST_DEVID field
STAT_ATAR: DB ' COM: '
LAST_CLINE DB ' '
STAT_EROR: DB ' ERR: '
LAST_EROR DB ' '
STAT_SECNO: DB ' SEC#: ####'
LSD_SECNO: DB '#' ; INT2DEC needs address of rightmost digit
STAT_RAM: DB ' RAM: ##'
LSD_RAM: DB '#K'
A_SPEED DB ' SPEED: '
SPEED   DB 'N$'; N - Normal; H - High
EVER_HI DB 0; 0 for never high speed, 'Y' for has been high
STAT_CLINE: DB '  $'
BLANK_LINE: DB  80 DUP (' '); For clearing a line without bios.
	DB '$'

; TAB_LINE is printed up to $ when PRNT_LINE encounters ASCII TAB (9)
; you can move the $ around to set the tab width. DEFAULT: 5 spaces

TAB_LINE: DB '     $                    '

RAM_SPOT: DB '00000'; temporary holding area for ram size string

; DEFAULT PORT ADDRESSES:

; These addresses will be used when the addresses given
; in the BIOS data area are found to be 0.

PORTS:  DW 03F8h, 02F8h, 03E8h, 02E8h; DOS PROGRAMMERS REF, PG 180

; Other variables associated with DEBUG status line:
OLD_DST  DB 0 ; BLANKIT saves old status of D_STLINE here
D_STLINE DB  0; 0 means do status, <>0 means don't.
ERR_CHAR DB  'Z'; Routines put their error identifier here, for use
; by the PUT_ERCH routine.

; Here are the characters defined for the ERROR field to date:

;	a - GET1 routine
;	b - PUT1 routine
;	c - PUT1A routine
;	d - JIFFY routine
;	e - a NAK was sent to the Atari
;       P - PRINTER timed out
;       S - WRITE to a simulated disk

COUNT_TIME:      DW 1; The timer routine, DO_TIME decrements this variable

; Variables for the FILE2PC function:

FTSTATS DB 0; see below...

; 0 means not in process (first time) 2 means in process, receiving data
; 1 means ESC pressed on PC, need to give bad status to next request

F2PC_HND DW 0; File handle assigned by DOS. 0 if not in process
F2P_STAT: DB 0,020h,0FFh,010h; In reverse order


; WARNING: For math below, order is important because if
; intermediate product L to R, is greater than 0FFFFh, the
; excess is truncated. Therefore, 720*128/16 produces incorrect
; result!! (this known for A86 assembler only) The 5th size listed
; is for custom size disks.

; The sizes below are: 64K, 92K, 133K, 184K
; Which are: 64K, 90K, 130K, 180K where "K"  is 1024 bytes

; 3.17 changed the "1050" enhanced density disk size from
; 1120 sectors (143K) to 1040 sectors (133K)

SIZES:	 DW 01000h,(128/16)*720,(128/16)*1040,(256/16)*720
	DW 0; dummy size for custom

; MIN_TABLE is offsets into the 4 structures which will be
; re-arranged  by ORDER to get disks with min STARS to max STARS.


MIN_TABLE: DW 0, BLOCK_SIZE, 2*BLOCK_SIZE, 3*BLOCK_SIZE
SORT_FLAG DB 0; 0 means made thru sort with no changes (ORDER)


ERROR	DB 'N'; SUBROUTINES CAN RETURN ERROR STATUS HERE
CONFIGD DB  0; 0 MEANS PORT HASN'T BEEN CONFIGURED

; DISK FILE INFO:

CATARI	DW 'N'+'I'+'C'+'K'+'A'+'T'+'A'+'R'+'I'; FILE TYPE I.D.
RD1:     DB 'Load Disk File into System...$'
RD2:     DB 'ENTER DISK # (1 to 8): $'
RD3:     DB 'ENTER FILESPEC: $'
TAG_RD3 DB 0 ; 0 means normal SIO2PC screen, 0FF means other
RDTS:    DB 'RAMDISK TOO SMALL FOR THIS FILE$'
WERF:    DB 'WARNING! ERROR READING FILE$'
REOF:    DB 'WARNING! READ END-OF-FILE EARLY$'
NATDSK:  DB 'THIS FILE IS NOT AN ATARI DISK FILE$'
FIXBUG: DB 'PRESS "Y" TO FORCE FILE SIZE TO STANDARD (FIX BUG)$'
REMIND: DB 'BE SURE TO WRITE FIXED FILE BACK TO DISK$'
RFSPEC:  DB 55 DUP (' '); Read File filespec area
LOAD_OPT DB ' '; user specified option given after pathname
	       ; 3.17: LOAD_OPT was formerly a label

; This is the area the disk header will be read into:

LBLHDR: ; Need a label for header area

HEADER    DW 0; Checksum ATARI
XSIZE     DW 0; Size this disk, in paragraphs
SEC_XSIZE DW 0; Sector size, this disk
HI_XSIZE  DW 0; hi bits of XSIZE, REV 3.00 added
H_FLAGS   DB 0 ; see DSK_FLAGS for meaning of bits
BAD_1ST   DW 0 ; location of "first" (or typical) bad sector
TUNUSED:  DB  5 DUP (0); Unused header bytes; if changed, then change
                        ; routine HEADER_0 which zeroes them

REMOTE  DB 0; 0 means command not in process, -1 means remote command
LAST_MCR DB 0; last byte put out to MCR, don't change if same...

S_NONE:  DB 'NONE',09Bh  ; String for RMT_READ to send when no disk
; REV 3.00 move MACROS from here to file MACROS.ASM

; PRINT_THRU DATA

; PSTATS is: last byte, bit 7 means intelligent controller, bit 0
; means invalid command frame, bit 1 means invalid data frame.
; third byte is AUX2  of last printer command.
; byte 2 is timeout in seconds
; byte 1 is unused
; Note, bytes are transmitted in reverse of order shown

PLENGTH DW 40; Length of printer data frame
PSTATS: DB 0,30,0,0 ; 30 was 10 before 3.13
PRINTHRU DB 0; 0 means not in PRINT_THRU mode.
PRBUFF: DB 121 DUP (0); 120 char buffer plus a '0'
PRNDEV DW 1; handle = 4 for printer, 1 for screen
PTR_CHOICE: DB 'Enter "P" for Printer, "S" for Screen, "F" for File [P,X,F]$'
EOL_CHOICE: DB 'Convert EOL to CR or CR/LF? (Y/N) [X]$'
LFS_ALSO: DB 'PRESS "Y" to add Linefeed in addition to CR [LF]$'
NO_PTHRU: DB 'PRINT_THRU mode disabled$'
PSTRIP:  DB 'Clear high bit to 0? (Y/N) [7]$'
EOLFIX  DB 0; 0 - don't translate, 1 = CR for EOL
LF_TOO DB 0; 0 means don't add LF to translation, 1 = do add it
PRNMASK DB 01111111xB; Mask to strip/don't strip high bit
C_TAB: DB 'Convert ATASCII TAB to PC TAB? (Y/N) [T]$'
CONV_TAB DB 0; 0 means DON'T convert 07Fh to 09h
APRNDEV DB 0; Storage ASCII letter choice
ACPF:    DB 'Closing printer output file$'

